/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.service.impl;

import com.bxm.kylin.cache.CacheKey;
import com.bxm.kylin.core.WeChatTicket;
import com.bxm.kylin.core.event.UuidReceivedEvent;
import com.bxm.kylin.core.service.WeChatService;
import com.bxm.kylin.utils.RestUtils;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.io.IOException;
import java.io.StringReader;
import java.util.EventObject;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class WeChatServiceImpl
implements WeChatService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeChatServiceImpl.class);
    private final EventPark eventPark;
    private final RestTemplate restTemplate;
    private Fetcher fetcher;
    private Updater updater;

    public WeChatServiceImpl(EventPark eventPark, RestTemplate restTemplate, Fetcher fetcher, Updater updater) {
        this.eventPark = eventPark;
        this.restTemplate = restTemplate;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public boolean isLoginSuccess() {
        WeChatTicket ticket = this.getTicket();
        if (null == ticket) {
            return false;
        }
        return StringUtils.isNotBlank((String)ticket.getCookie());
    }

    @Override
    public String jslogin() {
        String url = "https://login.wx.qq.com/jslogin?appid=wx782c26e4c19acffb&redirect_uri=https://wx.qq.com/cgi-bin/mmwebwx-bin/webwxnewloginpage&fun=new&lang=zh_CN&_=" + String.valueOf(System.currentTimeMillis());
        ResponseEntity<String> responseEntity = RestUtils.get(this.restTemplate, url);
        String body = (String)responseEntity.getBody();
        if (StringUtils.isBlank((String)body)) {
            return null;
        }
        Properties properties = WeChatServiceImpl.of(body);
        Object uuid = properties.get("window.QRLogin.uuid");
        if (null == uuid) {
            return null;
        }
        String str = uuid.toString();
        WeChatTicket ticket = this.getTicket();
        if (null == ticket) {
            ticket = new WeChatTicket();
        }
        ticket.setUuid(str);
        this.updateTicket(ticket);
        this.eventPark.post((EventObject)new UuidReceivedEvent(this, str));
        return str;
    }

    @Override
    public WeChatTicket getTicket() {
        WeChatTicket ticket = (WeChatTicket)this.fetcher.fetch(this.getTicketKey(), WeChatTicket.class);
        return ticket;
    }

    @Override
    public void updateTicket(WeChatTicket ticket) {
        this.updater.update(this.getTicketKey(), (Object)ticket);
    }

    @Override
    public void deleteTicket() {
        this.updater.remove(this.getTicketKey());
    }

    private KeyGenerator getTicketKey() {
        return CacheKey.MicroMessenger.ticket();
    }

    public static Properties of(String s) {
        s = s.replaceAll(";", "\n").replaceAll("\"", "");
        Properties p = new Properties();
        try {
            p.load(new StringReader(s));
        }
        catch (IOException e) {
            LOGGER.error("load: ", (Throwable)e);
        }
        return p;
    }

    public static Properties of1(String s) {
        s = s.replaceAll(";window", "\nwindow").replaceAll("\"", "").replace("'", "");
        Properties p = new Properties();
        try {
            p.load(new StringReader(s));
        }
        catch (IOException e) {
            LOGGER.error("load: ", (Throwable)e);
        }
        return p;
    }
}

