/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.shorturl.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.kylin.core.service.QqService;
import com.bxm.kylin.shorturl.ShortUrlException;
import com.bxm.kylin.shorturl.ShortUrlService;
import com.bxm.kylin.shorturl.ShortUrlType;
import com.bxm.warcar.utils.JsonHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TencentShortUrlServiceImpl
implements ShortUrlService {
    private static final Logger log = LoggerFactory.getLogger(TencentShortUrlServiceImpl.class);
    private final HttpClient httpClient = HttpClientBuilder.create().build();
    private final QqService qqService;

    public TencentShortUrlServiceImpl(QqService qqService) {
        this.qqService = qqService;
    }

    @Override
    public String create(String url) throws ShortUrlException {
        Map<String, String> map = this.create(new String[]{url});
        if (MapUtils.isEmpty(map)) {
            throw new ShortUrlException("\u65e0\u6cd5\u751f\u6210\u817e\u8baf\u77ed\u94fe\u63a5\uff0c\u672a\u77e5\u539f\u56e0\u3002");
        }
        return map.entrySet().iterator().next().getValue();
    }

    @Override
    public Map<String, String> create(String[] urls) throws ShortUrlException {
        if (!this.qqService.isLogin()) {
            throw new ShortUrlException("\u65e0\u6cd5\u751f\u6210\u817e\u8baf\u77ed\u94fe\u63a5\uff0c\u56e0\u4e3a\u8fd8\u6ca1\u6709\u767b\u5f55QQ\u3002");
        }
        return this.create0(urls);
    }

    @Override
    public ShortUrlType getType() {
        return ShortUrlType.Tencent;
    }

    private Map<String, String> create0(String[] urls) {
        if (ArrayUtils.isEmpty((Object[])urls)) {
            throw new ShortUrlException("\u65e0\u6548\u7684\u539f\u59cb\u94fe\u63a5\u3002");
        }
        String url = "http://openmobile.qq.com/api/url_change?type=1&mType=qb_share&value=" + this.encodeUrls(urls);
        HttpGet get = new HttpGet(url);
        get.setHeader((Header)new BasicHeader("Cookie", this.getCookie()));
        get.setHeader((Header)new BasicHeader("Referer", "https://im.qq.com/"));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new ShortUrlException("\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            InputStream content = entity.getContent();
            List lines = IOUtils.readLines((InputStream)content, (Charset)StandardCharsets.UTF_8);
            if (CollectionUtils.isEmpty((Collection)lines)) {
                throw new ShortUrlException("\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\u3002");
            }
            StringBuilder str = new StringBuilder();
            for (String line : lines) {
                str.append(line).append("\n");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)str.toString());
            Integer retCode = jsonObject.getInteger("retcode");
            String msg = jsonObject.getString("msg");
            if (null == retCode || retCode != 0) {
                throw new ShortUrlException("\u63a5\u53e3\u672a\u6b63\u5e38\u5904\u7406\uff0c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a" + msg);
            }
            JSONObject result = jsonObject.getJSONObject("result");
            if (null == result) {
                throw new ShortUrlException("\u975e\u6b63\u5e38\u7684\u54cd\u5e94\uff0cresult \u8282\u70b9\u4e3a\u7a7a\u3002");
            }
            JSONArray list = result.getJSONArray("list");
            if (null == list || list.size() == 0) {
                throw new ShortUrlException("\u975e\u6b63\u5e38\u7684\u54cd\u5e94\uff0clist \u8282\u70b9\u4e3a\u7a7a\u3002");
            }
            int size = list.size();
            if (urls.length != size) {
                throw new ShortUrlException("\u63a5\u53e3\u54cd\u5e94\u7684\u7ed3\u679c\u957f\u5ea6 " + size + " \u4e0e\u9884\u671f\u4e0d\u4e00\u81f4\u3002");
            }
            HashMap<String, String> rst = new HashMap<String, String>(size);
            for (int i = 0; i < size; ++i) {
                String shortUrl = list.getString(i);
                rst.put(urls[0], shortUrl);
            }
            return rst;
        }
        catch (IOException e) {
            log.error("create0: ", (Throwable)e);
            throw new ShortUrlException("\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\u3002");
        }
    }

    private String encodeUrls(String[] urls) {
        String str = JsonHelper.convert((Object)urls);
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private String getCookie() {
        Map<String, String> sessionCookie = this.qqService.getSessionCookie();
        String skey = sessionCookie.get("skey");
        String uin = sessionCookie.get("uin");
        if (StringUtils.isBlank((String)skey) || StringUtils.isBlank((String)uin)) {
            throw new ShortUrlException("QQ\u767b\u5f55\u8eab\u4efd\u4e0d\u5b8c\u6574\u3002" + sessionCookie);
        }
        return "skey=" + skey + ";" + "uin=" + uin + ";";
    }

    public static void main(String[] args) {
        String[] value = new String[]{"1", "2"};
        System.out.println(JsonHelper.convert((Object)value));
    }
}

