/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.checker.impl;

import com.bxm.kylin.checker.checker.CheckEnvironmentEnum;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.core.entity.BlacklistType;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.service.WeChatService;
import com.bxm.kylin.utils.DomainUtils;
import com.bxm.kylin.utils.RestUtils;
import com.bxm.kylin.utils.StringHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class MicroMessengerChecker
implements Checker {
    private static final Logger log = LoggerFactory.getLogger(MicroMessengerChecker.class);
    private WeChatService weChatService;
    private final RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();

    public MicroMessengerChecker(WeChatService weChatService) {
        this.weChatService = weChatService;
    }

    @Override
    public CheckEnvironmentEnum getCheckEnvironment() {
        return CheckEnvironmentEnum.MicroMessenger;
    }

    @Override
    public Checked check(CheckPlan plan, Domain domain) {
        String cookie = this.weChatService.getTicket().getCookie();
        String url = DomainUtils.getWholeUrl(domain);
        url = StringHelper.urlDecode(url);
        Checked checked = new Checked();
        checked.setCheckUrl(new String(url));
        if (StringUtils.isBlank((String)cookie)) {
            checked.setCheckResult(CheckResult.NOPASS);
            return checked;
        }
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Cookie", (Object)cookie);
        url = "https://wx2.qq.com/cgi-bin/mmwebwx-bin/webwxcheckurl?requrl=" + url;
        ResponseEntity<String> responseEntity = RestUtils.get(this.restTemplate, url, (MultiValueMap<String, String>)headers);
        int code = responseEntity.getStatusCodeValue();
        String html = (String)responseEntity.getBody();
        if (log.isDebugEnabled()) {
            log.debug("Wechat result html {}", (Object)html);
        }
        CheckResult result = this.checkMicroMessenger(html, plan.getExpectBodyRegex());
        if (log.isDebugEnabled()) {
            log.debug("Url checking result is {} of {}", (Object)result, (Object)url);
        }
        checked.setCheckResult(result);
        checked.setBody(html);
        checked.setStatusCode(code);
        return checked;
    }

    @Override
    public String getBlacklistFeature() {
        return "MicroMessenger";
    }

    @Override
    public BlacklistType getBlacklistType() {
        return BlacklistType.Browser;
    }
}

