/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.job.scheduler;

import com.bxm.kylin.checker.checker.CheckEnvironmentEnum;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.checker.job.scheduler.JobScheduler;
import com.bxm.kylin.checker.job.worker.JobWorkerDispatcher;
import com.bxm.kylin.core.entity.CheckEnvironment;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.service.ICheckEnvironmentService;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class QuartzJobScheduler
implements JobScheduler,
DisposableBean,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzJobScheduler.class);
    private final ICheckEnvironmentService checkEnvironmentService;
    private final Map<Integer, Checker> checkerMapping = Maps.newHashMap();
    private Scheduler scheduler;
    private ConfigurableApplicationContext applicationContext;

    public QuartzJobScheduler(ICheckEnvironmentService checkEnvironmentService) {
        this.checkEnvironmentService = checkEnvironmentService;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.applicationContext = event.getApplicationContext();
        this.postChecker(this.applicationContext);
        this.startScheduler(this.applicationContext);
    }

    private void startScheduler(ConfigurableApplicationContext applicationContext) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            Map beans = applicationContext.getBeansOfType(JobListener.class);
            if (MapUtils.isNotEmpty((Map)beans)) {
                for (JobListener listener : beans.values()) {
                    this.scheduler.getListenerManager().addJobListener(listener);
                }
            }
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void postChecker(ConfigurableApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(Checker.class);
        for (Map.Entry entry : beans.entrySet()) {
            Checker value = (Checker)entry.getValue();
            CheckEnvironmentEnum checkEnvironment = value.getCheckEnvironment();
            this.checkerMapping.put(checkEnvironment.getType(), value);
        }
    }

    public void destroy() {
        block2: {
            try {
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("shutdown: ", (Throwable)e);
            }
        }
    }

    @Override
    public boolean trigger(CheckPlan checkPlan) {
        MyJob myJob = this.create(checkPlan);
        return this.triggerJob(myJob);
    }

    @Override
    public boolean remove(CheckPlan checkPlan) {
        return this.removeJob(new MyJob(checkPlan, (ApplicationContext)this.applicationContext));
    }

    @Override
    public boolean triggerJob(MyJob job) {
        if (null == job) {
            return false;
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("job", (Object)job);
        JobDetail jobDetail = JobBuilder.newJob(JobWorkerDispatcher.class).setJobData(jobDataMap).withIdentity(job.getJobName(), job.getJobGroup()).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(job.getJobName(), job.getJobGroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getCronExpression())).build();
        try {
            Date date = this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Job [{}-{}] registry successful, Next fire at: {}", new Object[]{job.getJobGroup(), job.getJobName(), date});
            }
            return true;
        }
        catch (SchedulerException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean removeJob(MyJob job) {
        try {
            boolean flag = this.scheduler.deleteJob(new JobKey(job.getJobName(), job.getJobGroup()));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Job [{}-{}] has been removed!", (Object)job.getJobGroup(), (Object)job.getJobName());
            }
            return flag;
        }
        catch (SchedulerException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("", (Throwable)e);
            }
            return false;
        }
    }

    private MyJob create(CheckPlan checkPlan) {
        MyJob myJob = new MyJob(checkPlan, (ApplicationContext)this.applicationContext);
        CheckEnvironment checkEnvironment = (CheckEnvironment)this.checkEnvironmentService.getById(checkPlan.getEnvironmentId());
        Checker checker = this.checkerMapping.get(checkEnvironment.getEnvironment());
        myJob.setChecker(checker);
        return myJob;
    }
}

