/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.checker.trigger.AbstractTrigger;
import com.bxm.kylin.core.entity.CheckLog;
import com.bxm.kylin.core.service.ICheckLogService;
import com.bxm.kylin.utils.DomainUtils;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoggingTrigger
extends AbstractTrigger {
    private static final Logger log = LoggerFactory.getLogger(LoggingTrigger.class);
    private final ICheckLogService checkLogService;

    public LoggingTrigger(ICheckLogService checkLogService) {
        this.checkLogService = checkLogService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
        Checked checked;
        String fullName = job.getJobName();
        if (log.isDebugEnabled()) {
            log.debug("[{}] executed job: {}", (Object)fullName, (Object)job);
            log.debug("[{}] return: {}", (Object)fullName, (Object)result);
        }
        if (null == (checked = job.getChecked())) {
            return;
        }
        CheckLog checkLog = new CheckLog();
        checkLog.setBody(checked.getBody());
        checkLog.setCheckTime(LocalDateTime.now());
        checkLog.setCheckUrl(DomainUtils.getWholeUrl(job.getDomain()));
        checkLog.setDomain(job.getDomain().getDomain());
        checkLog.setEnvironment(job.getCheckEnvironment().getEnvironment());
        checkLog.setHeaders(checked.getHeaders());
        checkLog.setPassed(result.getValue());
        checkLog.setPlanId(job.getId());
        checkLog.setStatusCode(checked.getStatusCode());
        this.checkLogService.save(checkLog);
    }

    @Override
    protected void doPassed(MyJob job) {
    }

    @Override
    protected void doNoPass(MyJob job) {
    }
}

