/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.checker.trigger.AbstractTrigger;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.service.IDomainService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UpdateDomainStatusTrigger
extends AbstractTrigger {
    private static final Logger log = LoggerFactory.getLogger(UpdateDomainStatusTrigger.class);
    private final IDomainService domainService;

    public UpdateDomainStatusTrigger(IDomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
    }

    @Override
    protected void doPassed(MyJob job) {
        this.handle(job, 1);
    }

    @Override
    protected void doNoPass(MyJob job) {
        this.handle(job, 0);
    }

    private void handle(MyJob job, int status) {
        Checker checker = job.getChecker();
        if (!checker.isGlobalBlacklist()) {
            return;
        }
        Domain domain = job.getDomain();
        if (domain.getStatus() == status) {
            return;
        }
        domain.setStatus(status);
        domain.setModifyTime(LocalDateTime.now());
        if (!this.domainService.updateById(domain)) {
            log.warn("[{}] Domain update fail!", (Object)domain.getId());
        }
    }
}

