#!/bin/bash

if [ ! -f ~/run/kylin-checker.pid ]; then
  echo "Server [kylin-checker] doest not started!"
  exit
fi

pid=`cat ~/run/kylin-checker.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in kylin-checker.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [kylin-checker] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [kylin-checker] cannot stop, Please check pid file 'kylin-checker.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [kylin-checker] has been stoped!"
fi

rm -f ~/run/kylin-checker.pid