package com.bxm.kylin._super.sdk.webhook;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.MapHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2023-01-11
 * @since 1.0
 */
@Slf4j
public class KylinWebhookHandlerFactory implements BeanPostProcessor {

    private final Map<String, List<KylinWebhookHandler>> handlers = Maps.newHashMap();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof KylinWebhookHandler) {
            KylinWebhookHandler handler = (KylinWebhookHandler) bean;
            String e = handler.event();
            MapHelper.get(handlers, e, Lists.newArrayList()).add(handler);
            log.info("{} KylinWebhookHandler {} register successful.", e, handler);
        }
        return bean;
    }

    public void doWebhookHandle(String body) {
        JSONObject object = JSONObject.parseObject(body);
        String event = object.getString("event");
        List<KylinWebhookHandler> handlers = this.handlers.get(event);
        handlers.forEach((handler -> {
            handler.handle(object.getJSONObject("entity"));
        }));
    }
}
