/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin._super.sdk;

import com.alibaba.fastjson.JSONObject;
import com.bxm.kylin._super.sdk.KylinApiClient;
import com.bxm.kylin._super.sdk.KylinProperties;
import com.bxm.kylin._super.sdk.modal.CheckPlan;
import com.bxm.kylin._super.sdk.modal.CheckPlanPage;
import com.bxm.kylin._super.sdk.modal.Domain;
import com.bxm.kylin._super.sdk.modal.DomainGroup;
import com.bxm.kylin._super.sdk.modal.DomainGroupPage;
import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.http.pool.RestTemplatePool;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultKylinApiClientImpl
implements KylinApiClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKylinApiClientImpl.class);
    private final Fetcher fetcher;
    private final RestTemplatePool rest;
    private final KylinProperties kylinProperties;

    public DefaultKylinApiClientImpl(Fetcher fetcher, KylinProperties kylinProperties) {
        this.fetcher = fetcher;
        this.rest = new RestTemplatePool(new HttpProperties());
        this.kylinProperties = kylinProperties;
    }

    @Override
    public List<Domain> getAvailableDomains(String groupId, String ua, String ip) {
        return this.getAvailableDomains(groupId, ua, ip, "");
    }

    @Override
    public List<Domain> getAvailableDomains(String groupId, String ua, String ip, String path) {
        HashMap params = Maps.newHashMap();
        params.put("groupId", groupId);
        params.put("ua", ua);
        params.put("ip", ip);
        params.put("path", path);
        try {
            String url = this.kylinProperties.getRedirectHost() + "/domains?groupId={groupId}&ua={ua}&ip={ip}&path={path}";
            HttpEntity<String> exchange = this.post(url, String.class, params);
            if (!exchange.hasBody()) {
                return null;
            }
            return JSONObject.parseArray((String)((String)exchange.getBody()), Domain.class);
        }
        catch (Exception e) {
            log.error("post: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DomainGroup> getDomainGroups() {
        return this.fetcher.fetchList(() -> KeyBuilder.build((Object[])new Object[]{"tmp", "kylin", "domainGroups"}), (DataExtractor)new DataExtractor<List<DomainGroup>>(){

            public List<DomainGroup> extract() {
                HashMap params = Maps.newHashMap();
                params.put("size", 100);
                params.put("current", 1);
                try {
                    String url = DefaultKylinApiClientImpl.this.kylinProperties.getApiHost() + "/domain-group/page-query?size={size}&current={current}";
                    HttpEntity entity = DefaultKylinApiClientImpl.this.get(url, DomainGroupPage.class, params);
                    DomainGroupPage body = (DomainGroupPage)entity.getBody();
                    if (Objects.isNull(body)) {
                        return null;
                    }
                    return body.getRecords();
                }
                catch (Exception e) {
                    log.error("exchange: ", (Throwable)e);
                    return null;
                }
            }
        }, DomainGroup.class, 300);
    }

    @Override
    public CheckPlan createCheckPlan(Long envId, Long groupId, Long domainId, String sourceUrl) {
        return this.createCheckPlan(envId, groupId, domainId, sourceUrl, "");
    }

    @Override
    public CheckPlan createCheckPlan(Long envId, Long groupId, Long domainId, String sourceUrl, String remark) {
        CheckPlan exists;
        UriComponents build = UriComponentsBuilder.fromUriString((String)sourceUrl).build();
        String path = build.getPath();
        if (Objects.nonNull(groupId) && Objects.nonNull(exists = this.getCheckPlanOnCreateJustNow(envId, groupId, domainId, path))) {
            return exists;
        }
        CheckPlan checkPlan = CheckPlan.builder().environmentId(envId).domainId(domainId).checkPath(path).expectStatusCode(200).cronExpression("0 0/1 * * * ?").status(1).webhook(this.kylinProperties.getWebhook()).remark(remark).build();
        try {
            String url = this.kylinProperties.getApiHost() + "/check-plan/put";
            HttpEntity<CheckPlan> exchange = this.put(url, CheckPlan.class, checkPlan, Maps.newHashMap());
            CheckPlan res = (CheckPlan)exchange.getBody();
            if (Objects.nonNull(res)) {
                res.setLastCheckResult(1);
            }
            return res;
        }
        catch (Exception e) {
            log.error("exchange: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteCheckPlan(Long checkPlanId) {
        try {
            String url = this.kylinProperties.getApiHost() + "/check-plan/delete/" + checkPlanId;
            this.delete(url, String.class, Maps.newHashMap());
        }
        catch (Exception e) {
            log.info("{} delete checkPlan occur error: {}", (Object)checkPlanId, (Object)e.getMessage());
        }
    }

    private CheckPlan getCheckPlanOnCreateJustNow(Long envId, Long groupId, Long domainId, String path) {
        HashMap params = Maps.newHashMap();
        params.put("size", 100);
        params.put("current", 1);
        params.put("environmentId", envId);
        params.put("groupId", groupId);
        params.put("domainId", domainId);
        params.put("status", "1");
        try {
            String url = this.kylinProperties.getApiHost() + "/check-plan/page-query?size={size}&current={current}&environmentId={environmentId}&groupId={groupId}&domainId={domainId}&status={status}";
            HttpEntity<CheckPlanPage> entity = this.get(url, CheckPlanPage.class, params);
            CheckPlanPage body = (CheckPlanPage)entity.getBody();
            if (Objects.isNull(body)) {
                return null;
            }
            List<CheckPlan> records = body.getRecords();
            Optional<CheckPlan> exists = records.stream().filter(e -> e.isNewPlan() && StringUtils.equalsIgnoreCase((String)e.getCheckPath(), (String)path)).findFirst();
            return exists.orElse(null);
        }
        catch (Exception e2) {
            log.error("exchange: ", (Throwable)e2);
            return null;
        }
    }

    private <T> HttpEntity<T> get(String url, Class<T> responseType, Map<String, Object> params) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.createHeaders());
        RestTemplate restTemplate = this.rest.builder();
        return restTemplate.exchange(url, HttpMethod.GET, httpEntity, responseType, params);
    }

    private <T> HttpEntity<T> post(String url, Class<T> responseType, Map<String, Object> params) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.createHeaders());
        RestTemplate restTemplate = this.rest.builder();
        return restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseType, params);
    }

    private <T> HttpEntity<T> put(String url, Class<T> responseType, Object body, Map<String, Object> params) {
        HttpHeaders httpHeaders = this.createHeaders();
        httpHeaders.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
        RestTemplate restTemplate = this.rest.builder();
        return restTemplate.exchange(url, HttpMethod.PUT, httpEntity, responseType, params);
    }

    private <T> HttpEntity<T> delete(String url, Class<T> responseType, Map<String, Object> params) {
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)this.createHeaders());
        RestTemplate restTemplate = this.rest.builder();
        return restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, responseType, params);
    }

    private HttpHeaders createHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("x-kylin-super-sdk", TypeHelper.castToString((Object)System.currentTimeMillis()));
        return headers;
    }
}

