/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin._super.sdk.webhook;

import com.alibaba.fastjson.JSONObject;
import com.bxm.kylin._super.sdk.webhook.KylinWebhookHandler;
import com.bxm.warcar.utils.MapHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class KylinWebhookHandlerFactory
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(KylinWebhookHandlerFactory.class);
    private final Map<String, List<KylinWebhookHandler>> handlers = Maps.newHashMap();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof KylinWebhookHandler) {
            KylinWebhookHandler handler = (KylinWebhookHandler)bean;
            String e = handler.event();
            ((List)MapHelper.get(this.handlers, (Object)e, (Object)Lists.newArrayList())).add(handler);
            log.info("{} KylinWebhookHandler {} register successful.", (Object)e, (Object)handler);
        }
        return bean;
    }

    public void doWebhookHandle(String body) {
        JSONObject object = JSONObject.parseObject((String)body);
        String event = object.getString("event");
        List<KylinWebhookHandler> handlers = this.handlers.get(event);
        handlers.forEach(handler -> handler.handle(object.getJSONObject("entity")));
    }
}

