package com.bxm.kylin._super.sdk;

import com.bxm.kylin._super.sdk.modal.CheckPlan;

import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @date 2021-08-23
 * @since 1.0
 */
public interface Kylin {

    /**
     * 刷新指定ID集合的监测
     * @param ids ID集合，如果为空则刷新所有的
     * @param groupId GROUP ID
     */
    void refresh(Set<String> ids, String groupId);

    /**
     * 开始监控以及替换可用的URL
     *
     * @param id ID
     * @param groupId Group Id
     * @param url URL
     */
    void start(String id, String groupId, String url);

    /**
     * 开始监控以及替换可用的URL
     *
     * @param id ID
     * @param groupId Group Id
     * @param url URL
     * @param remark 备注
     */
    void start(String id, String groupId, String url, String remark);

    /**
     * 关闭监控及所有的配置
     * @param id ID
     */
    void close(String id);

    /**
     * 关闭监控及所有的配置，可以指定是否包括已配置过的域名。
     *
     * @param id ID
     * @param deleteHistoryDomains 是否删除配置过的域名。
     */
    void close(String id, boolean deleteHistoryDomains);

    /**
     * 监测计划发生变化的处理
     *
     * @param checkPlan 监测计划
     */
    void changed(CheckPlan checkPlan);

    /**
     * 获取当前指定 ID 可用的URL
     *
     * @param id ID
     * @return 如果为 null，表示没有可用或未开启过监控。
     */
    String getUrl(String id);

    /**
     * 获取所有 ID 可用的URL
     *
     * @return 所有已配置的 ID 与 URL 映射
     */
    Map<String, String> getAllUrl();

    /**
     * 获取所有 ID 当前配置的监测计划 ID
     * @return 所有已配置的 ID 与监测计划 ID 映射
     */
    Map<String, String> getAllCheckPlan();

    /**
     * 获取所有 ID 当前配置的监测计划
     * @return 所有已配置的 ID 与监测计划
     */
    Map<String, CheckPlan> getAllCheckPlan2();

    /**
     * 获取指定 ID 的监测计划
     * @param id ID
     * @return 监测计划
     */
    CheckPlan getCheckPlan(String id);

    /**
     * 获取指定 ID 已睡眠的监测计划
     * @param id ID
     * @return 已睡眠监测计划
     */
    CheckPlan getSleepCheckPlan(String id);

    void sleep(String id) throws IllegalStateException;

    /**
     * 唤醒指定 ID
     * @param id ID
     */
    void wakeup(String id) throws Exception;

    /**
     * 异步唤醒指定 ID
     * @param id ID
     */
    void asyncWakeup(String id);

    /**
     * 返回 CacheKey
     * @return CacheKey
     */
    CacheKey getCacheKey();
}
