package com.bxm.kylin._super.sdk;

import com.bxm.kylin._super.sdk.modal.*;

import java.util.List;

/**
 * @author allen
 * @date 2021-08-23
 * @since 1.0
 */
public interface KylinApiClient {

    List<Domain> getAvailableDomains(String groupId, String ua, String ip);

    List<Domain> getAvailableDomains(String groupId, String ua, String ip, String path);

    List<DomainGroup> getDomainGroups();

    CheckPlan createCheckPlan(CreateCheckPlanParam param);

    void deleteCheckPlan(Long checkPlanId);

    /**
     * 返回域名是否可用
     * @param domainId 域名ID
     * @return 只有域名不存在或禁用了才会返回false。异常情况也会返回 true。
     */
    boolean isAvailableDomain(Long domainId);
}
