package com.bxm.kylin._super.sdk.modal;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;

/**
 * @author allen
 * @date 2021-06-08
 * @since 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CheckPlan {
    public static final int ENABLE = 1;
    public static final int DISABLE = 0;

    private Long id;

    private Long environmentId;

    private Long domainId;

    /**
     * 监测时使用的路径，如果为空则使用域名预留的路径。
     */
    private String checkPath;

    /**
     * Expect status code for http response.
     */
    private Integer expectStatusCode;

    /**
     * Expect body regex for http response.
     */
    private String expectBodyRegex;

    /**
     * Cron expression
     */
    private String cronExpression;

    /**
     * 0- disabled / 1- enabled
     */
    private Integer status;

    /**
     * 最后一次监测结果：0-未通过、1-通过
     */
    private Integer lastCheckResult;

    /**
     * 可用性变化通知地址。
     */
    private String webhook;

    /**
     * 监测次数
     */
    private Long times;

    private String remark;

    /**
     * SleepTime
     */
    private LocalDateTime sleepTime;
    /**
     * Sleep GroupID
     */
    private String sleepGroupId;
    /**
     * Sleep URL
     */
    private String sleepUrl;

    public boolean isAvailable() {
        return Objects.equals(lastCheckResult, ENABLE);
    }

    public boolean isNewPlan() {
        return Optional.ofNullable(times).orElse(0L) == 0;
    }
}
