package com.bxm.kylin._super.sdk.modal;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author huxiao
 * @date 2024/5/13
 * @since 1.0.0
 */
@Data
@Accessors(chain = true)
public class DomainRo {
    private Long id;

    private String groupId;

    /**
     * www.big-mouth.cn
     */
    private String domain;

    /**
     * 1- HTTP / 2- HTTPS
     */
    private Integer protocol;

    /**
     * check uri. e.g. /index.html
     */
    private String uri;

    /**
     * 正常情况下的响应码
     */
    private Integer statusCode;

    /**
     * 0- disabled / 1- enabled / 2- using
     */
    private Integer status;

    /**
     * 1- 已删除 / 0- 未删除
     */
    private Integer deleted;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    /**
     * 0- No / 1- Yes
     */
    private Integer safety;

    public boolean isAvailable() {
        return !Objects.equals(status, 0);
    }
}
