/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportExcelUtil {
    private static final int IMPORT_MIN_ROW_NO = 1;
    private static final int IMPORT_MIN_SHEET_NO = 1;
    private static final int IMPORT_MAX_SHEET_NO = 1;
    private static final int READ_START_ROW_NO = 2;
    private static final int READ_START_COLUMN_NO = 2;

    public static List<Map<Integer, Object>> dealDataForExcel(String fileName, File file, int importMaxRowNo) throws Exception, ValidateException {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            throw new ValidateException("FUL0007");
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (StringUtil.isBlank((CharSequence)suffix)) {
            throw new ValidateException("FUL0013");
        }
        List<Map<Integer, Object>> list = null;
        if (StringUtil.equals((CharSequence)suffix, (CharSequence)"xls")) {
            list = ImportExcelUtil.dealDataForXls(file, importMaxRowNo);
        } else if (StringUtil.equals((CharSequence)suffix, (CharSequence)"xlsx")) {
            list = ImportExcelUtil.dealDataForXlsx(file, importMaxRowNo);
        } else {
            throw new ValidateException("FUL0013");
        }
        return list;
    }

    private static List<Map<Integer, Object>> dealDataForXlsx(File file, int importMaxRowNo) throws Exception, ValidateException {
        ArrayList<Map<Integer, Object>> list = new ArrayList<Map<Integer, Object>>();
        XSSFWorkbook hwb = null;
        hwb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        if (hwb != null) {
            int sheetCount = hwb.getNumberOfSheets();
            if (sheetCount < 1) {
                throw new ValidateException("FUL0014");
            }
            for (int sheetIndex = 0; sheetIndex < 1; ++sheetIndex) {
                XSSFSheet sheet = hwb.getSheetAt(sheetIndex);
                if (sheet == null) continue;
                int totalRowNo = sheet.getLastRowNum() - 1;
                if (totalRowNo < 1) {
                    throw new ValidateException("FUL0014");
                }
                if (totalRowNo > importMaxRowNo) {
                    throw new ValidateException("\u6279\u91cf\u5bfc\u5165\u6bcf\u6b21\u6700\u591a\u53ea\u80fd\u5bfc\u5165" + importMaxRowNo + "\u6761\u6570\u636e");
                }
                for (int i = 2; i < sheet.getLastRowNum(); ++i) {
                    XSSFRow row = sheet.getRow(i);
                    if (row == null) continue;
                    HashMap<Integer, String> map = new HashMap<Integer, String>();
                    for (int j = 1; j < row.getLastCellNum(); ++j) {
                        XSSFCell cell = row.getCell(j);
                        if (cell == null) continue;
                        String cellValue = "";
                        if (cell.getCellType() == 0 || cell.getCellType() == 2) {
                            HSSFDataFormatter dataFormatter = new HSSFDataFormatter();
                            cellValue = dataFormatter.formatCellValue((Cell)cell);
                        } else {
                            cell.setCellType(1);
                            cellValue = cell.getStringCellValue();
                        }
                        if (!StringUtil.isNotBlank((CharSequence)cellValue)) continue;
                        String[] item = cellValue.split("[.]");
                        if (1 < item.length && "0".equals(item[1])) {
                            cellValue = item[0];
                        }
                        map.put(j, cellValue);
                    }
                    if (map == null || map.size() <= 0) continue;
                    list.add(map);
                }
            }
        }
        if (list == null || list.size() == 0) {
            throw new ValidateException("FUL0014");
        }
        return list;
    }

    private static List<Map<Integer, Object>> dealDataForXls(File file, int importMaxRowNo) throws Exception, ValidateException {
        ArrayList<Map<Integer, Object>> list = new ArrayList<Map<Integer, Object>>();
        HSSFWorkbook hwb = null;
        hwb = new HSSFWorkbook((InputStream)new FileInputStream(file));
        if (hwb != null) {
            int sheetCount = hwb.getNumberOfSheets();
            if (sheetCount < 1) {
                throw new ValidateException("FUL0014");
            }
            for (int sheetIndex = 0; sheetIndex < 1; ++sheetIndex) {
                HSSFSheet sheet = hwb.getSheetAt(sheetIndex);
                if (sheet == null) continue;
                int totalRowNo = sheet.getLastRowNum() - 1;
                if (totalRowNo < 1) {
                    throw new ValidateException("FUL0014");
                }
                if (totalRowNo > importMaxRowNo) {
                    throw new ValidateException("\u6279\u91cf\u5bfc\u5165\u6bcf\u6b21\u6700\u591a\u53ea\u80fd\u5bfc\u5165" + importMaxRowNo + "\u6761\u6570\u636e");
                }
                for (int i = 2; i <= totalRowNo; ++i) {
                    HSSFRow row = sheet.getRow(i);
                    if (row == null) continue;
                    HashMap<Integer, String> map = new HashMap<Integer, String>();
                    for (int j = 1; j < row.getLastCellNum(); ++j) {
                        HSSFCell cell = row.getCell(j);
                        if (cell == null) continue;
                        String cellValue = "";
                        if (cell.getCellType() == 0 || cell.getCellType() == 2) {
                            HSSFDataFormatter dataFormatter = new HSSFDataFormatter();
                            cellValue = dataFormatter.formatCellValue((Cell)cell);
                        } else {
                            cell.setCellType(1);
                            cellValue = cell.getStringCellValue();
                        }
                        if (!StringUtil.isNotBlank((CharSequence)cellValue)) continue;
                        String[] item = cellValue.split("[.]");
                        if (1 < item.length && "0".equals(item[1])) {
                            cellValue = item[0];
                        }
                        map.put(j, cellValue);
                    }
                    if (map == null || map.size() <= 0) continue;
                    list.add(map);
                }
            }
        }
        if (list == null || list.size() == 0) {
            throw new ValidateException("FUL0014");
        }
        return list;
    }
}

