/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.log.service.mongo;

import com.bxm.log.dal.mongo.LogsDao;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    @Autowired
    private LogsDao logsDao;

    public Boolean add(LogModel model) {
        LogModel result = (LogModel)this.logsDao.save((Object)model, model.getCollectionName());
        if (result == null) {
            return false;
        }
        return true;
    }

    public Page<LogModel> findBykeyworkds(LogModelDto model) {
        Query query = new Query();
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getOperationType())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operationType").is((Object)model.getOperationType()));
        }
        if (model != null && model.getStartDateTime() != null && model.getEndDateTime() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"dateTime").gte((Object)new Date(model.getStartDateTime())).lte((Object)new Date(model.getEndDateTime())));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getAdticketId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"adticketId").is((Object)model.getAdticketId()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getAdticketIds())) {
            String[] ids = model.getAdticketIds().split(",");
            List<String> list = Arrays.asList(ids);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"adticketId").in(list));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getKeywords())) {
            query.addCriteria((CriteriaDefinition)new Criteria(model.getKeywords()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getUserAccount())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userAccount").is((Object)model.getUserAccount()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getLogInfo())) {
            String param = model.getLogInfo().replaceAll("\\{[^}]*\\}", "");
            Pattern pattern = Pattern.compile("^.*" + param + ".*$");
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"logInfo").regex(pattern), Criteria.where((String)"content").regex(pattern)});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getParentAccount())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentAccount").is((Object)model.getParentAccount()));
        }
        Page page = this.logsDao.findPage(model.getPageNum(), model.getPageSize(), query, model.getCollectionName());
        return page;
    }

    public List<LogModel> exportLogs(LogModelDto model) {
        Query query = new Query();
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getOperationType())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"operationType").is((Object)model.getOperationType()));
        }
        if (model != null && model.getStartDateTime() != null && model.getEndDateTime() != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"dateTime").gte((Object)new Date(model.getStartDateTime())).lte((Object)new Date(model.getEndDateTime())));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getAdticketId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"adticketId").is((Object)model.getAdticketId()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getAdticketIds())) {
            String[] ids = model.getAdticketIds().split(",");
            List<String> list = Arrays.asList(ids);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"adticketId").in(list));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getKeywords())) {
            query.addCriteria((CriteriaDefinition)new Criteria(model.getKeywords()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getUserAccount())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userAccount").is((Object)model.getUserAccount()));
        }
        if (model != null && StringUtils.isNotBlank((CharSequence)model.getParentAccount())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentAccount").is((Object)model.getParentAccount()));
        }
        List list = this.logsDao.exportLogs(query, model.getCollectionName());
        return list;
    }
}

