/*
 * Decompiled with CFR 0.152.
 */
package com.tinify;

import com.tinify.AccountException;
import com.tinify.Client;
import com.tinify.ClientException;
import com.tinify.Source;
import java.io.IOException;

public class Tinify {
    private static String key;
    private static String appIdentifier;
    private static String proxy;
    private static int compressionCount;
    private static Client client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client client() {
        if (key == null) {
            throw new AccountException("Provide an API key with Tinify.setKey(...)");
        }
        if (client != null) {
            return client;
        }
        Class<Tinify> clazz = Tinify.class;
        synchronized (Tinify.class) {
            if (client == null) {
                client = new Client(key, appIdentifier, proxy);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public static void setKey(String key) {
        Tinify.key = key;
        client = null;
    }

    public static void setProxy(String proxy) {
        Tinify.proxy = proxy;
        client = null;
    }

    public static void setAppIdentifier(String identifier) {
        appIdentifier = identifier;
        client = null;
    }

    public static Source fromFile(String path) throws IOException {
        return Source.fromFile(path);
    }

    public static Source fromBuffer(byte[] buffer) {
        return Source.fromBuffer(buffer);
    }

    public static Source fromUrl(String url) {
        return Source.fromUrl(url);
    }

    public static boolean validate() {
        try {
            Tinify.client().request(Client.Method.POST, "/shrink");
        }
        catch (AccountException ex) {
            if (ex.status == 429) {
                return true;
            }
            throw ex;
        }
        catch (ClientException ex) {
            return true;
        }
        return false;
    }

    public static String key() {
        return key;
    }

    public static String proxy() {
        return proxy;
    }

    public static String appIdentifier() {
        return appIdentifier;
    }

    public static void setCompressionCount(int count) {
        compressionCount = count;
    }

    public static int compressionCount() {
        return compressionCount;
    }

    static {
        compressionCount = 0;
    }
}

