#!/bin/bash

ACTIVE="$1"
if [ -z "$ACTIVE" ]; then
  ACTIVE="production"
  echo "Use default profile: $ACTIVE"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/logs-web.pid ]; then
  echo "Server [logs-web] pid file has been exists!";
  exit
fi

HEAP_MEMORY=256m
SERVER_JAR=`ls ../lib/logs-web-2.0.0-SNAPSHOT.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms${HEAP_MEMORY} -Xmx${HEAP_MEMORY} -XX:+HeapDumpOnOutOfMemoryError -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/logs-web.pid