#!/bin/bash

if [ ! -f ~/run/logs-web.pid ]; then
  echo "Server [logs-web] doest not started!"
  exit
fi

pid=`cat ~/run/logs-web.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in logs-web.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [logs-web] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [logs-web] cannot stop, Please check pid file 'logs-web.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [logs-web] has been stoped!"
fi

rm -f ~/run/logs-web.pid