/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.cm;

import com.bxm.lovelink.cm.data.TableHandler;
import com.bxm.lovelink.cm.data.TableHandlerFactory;
import com.bxm.lovelink.cm.mq.CanalMessageListener;
import com.bxm.lovelink.cm.mq.CanalMqFetcher;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.rocketmq.RocketmqProperties;
import com.bxm.warcar.mq.rocketmq.RocketmqConsumer;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;

public class CmAutoConfiguration {
    @Bean
    public TableHandlerFactory tableHandlerFactory(ObjectProvider<Collection<TableHandler<?>>> tableHandlers) {
        Collection handlers = (Collection)tableHandlers.getIfAvailable(Lists::newArrayList);
        return new TableHandlerFactory(handlers);
    }

    @Bean
    public CanalMessageListener canalMessageListener(ObjectProvider<CanalMqFetcher> canalMqFetcher, TableHandlerFactory tableHandlerFactory) {
        CanalMqFetcher fetcher = (CanalMqFetcher)canalMqFetcher.getIfAvailable();
        if (Objects.isNull(fetcher)) {
            throw new BeanCreationException("\u4f7f\u7528Canal\u76d1\u542c\u5668\uff0c\u5fc5\u987b\u521b\u5efa\u4e00\u4e2a CanalMqFetcher \u63a5\u53e3\u5b9e\u73b0\u7c7b\u5e76\u6ce8\u518c\u5230Spring\u3002");
        }
        return new CanalMessageListener(fetcher, tableHandlerFactory);
    }

    @Bean(name={"cmCanalMessageConsumer"}, initMethod="init", destroyMethod="destroy")
    protected RocketmqConsumer cmCanalMessageConsumer(CanalMessageListener canalMessageListener, RocketmqProperties properties) {
        String nameSrvAddr = properties.getNameSrvAddr();
        String consumerId = canalMessageListener.getConsumerId();
        Map brokerAddrAliasMap = properties.getBrokerAddrAliasMap();
        return new RocketmqConsumer(nameSrvAddr, (SingleMessageListener)canalMessageListener, consumerId, brokerAddrAliasMap);
    }
}

