package com.bxm.lovelink.cm.data;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * Canal data for mysql binlog
 * @author Allen Hu
 * @date 2025/6/19
 */
@Data
public class Binlog {

    public static final String TYPE_INSERT = "INSERT";
    public static final String TYPE_UPDATE = "UPDATE";
    public static final String TYPE_DELETE = "DELETE";

    private List<Map<String, Object>> data;
    private String database;
    private Long es;
    private Long id;
    private Boolean isDdl;
    private Map<String, String> mysqlType;
    private List<Map<String, Object>> old;
    private List<String> pkNames;
    private String sql;
    private Map<String, Object> sqlType;
    private String table;
    private Long ts;
    private String type;

    public boolean isDelete() {
        return "DELETE".equals(type);
    }

    public boolean isUpdate() {
        return "UPDATE".equals(type);
    }
}
