package com.bxm.lovelink.cm.data;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.aspectj.lang.ProceedingJoinPoint;

/**
 * 简单的指标统计切面工具类，用于统计服务方法的执行次数和耗时
 *
 * @author Allen Hu
 * @date 2025/10/30
 */
public class SimpleMicrometerAspectTool implements MeterBinder {

    private MeterRegistry meterRegistry;
    private final boolean timerEnabled = true;

    @Override
    public void bindTo(MeterRegistry registry) {
        this.meterRegistry = registry;
    }

    public Object doMeter(ProceedingJoinPoint pjp) throws Throwable {
        if (null != meterRegistry) {
            String className = pjp.getTarget().getClass().getSimpleName();
            String methodName = pjp.getSignature().getName();
            Timer.Sample sample = null;
            if (timerEnabled) {
                sample = Timer.start(meterRegistry);
            }
            try {
                Counter.builder("service.execution.count")
                        .description("Count of service methods execution")
                        .tag("service", className)
                        .tag("method", methodName)
                        .register(meterRegistry)
                        .increment();
                return pjp.proceed();
            } catch (Throwable e) {
                Counter.builder("service.execution.count.error")
                        .description("Count of service methods execution error")
                        .tag("service", className)
                        .tag("method", methodName)
                        .register(meterRegistry)
                        .increment();
                throw e;
            } finally {
                if (timerEnabled) {
                    sample.stop(Timer.builder("service.execution.time")
                            .description("Time spent on service methods")
                            .tag("service", className)
                            .tag("method", methodName)
                            .register(meterRegistry));
                }
            }
        } else {
            return pjp.proceed();
        }
    }
}
