package com.bxm.lovelink.cm.data;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 *
 * @author Allen Hu
 * @date 2025/6/19
 */
@Slf4j
public class TableHandlerFactory {

    private final Map<String, TableHandler<?>> tableHandlerMap;

    public TableHandlerFactory(Collection<TableHandler<?>> tableHandlers) {
        this.tableHandlerMap = tableHandlers.stream().collect(Collectors.toMap(TableHandler::ofTableName, syncStrategy -> syncStrategy));
    }

    /**
     * 处理表数据，目前只会处理修改和删除的数据。
     *
     * @param binlog Binlog日志对象
     * @throws Exception 处理异常
     */
    public void handle(Binlog binlog, String sourceBinLog) throws Exception {
        String table = binlog.getTable();
        TableHandler<?> tableHandler = tableHandlerMap.get(table);
        if (null == tableHandler) {
            return;
        }

        if (binlog.getIsDdl()) {
            log.info("IGNORE DDL: {}", sourceBinLog);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("SYNC: {}", sourceBinLog);
        }
        List<Map<String, Object>> data = binlog.getData();
        String jsonString = JSONObject.toJSONString(data);

        if (binlog.isDelete()) {
            Class<?> clazz = tableHandler.getDataClass();
            List<?> dataList = JSONObject.parseArray(jsonString, clazz);
            ((TableHandler<Object>) tableHandler).onDelete((List<Object>) dataList);
        } else if (binlog.isUpdate()) {
            Class<?> clazz = tableHandler.getDataClass();
            List<?> dataList = JSONObject.parseArray(jsonString, clazz);
            List<Map<String, Object>> old = binlog.getOld();
            List<Set<String>> updateColumns = old.stream().map(Map::keySet).collect(Collectors.toList());
            ((TableHandler<Object>) tableHandler).onUpdate((List<Object>) dataList, updateColumns);
        } else {
            Class<?> clazz = tableHandler.getDataClass();
            List<?> dataList = JSONObject.parseArray(jsonString, clazz);
            ((TableHandler<Object>) tableHandler).onInsert((List<Object>) dataList);
        }
    }

}
