package com.bxm.lovelink.cm.data;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.context.annotation.Configuration;

/**
 * 简单的指标统计切面，用于统计服务方法的执行次数和耗时
 *
 * @author Allen Hu
 * @date 2025/9/17
 */
@Slf4j
@Aspect
@Configuration
public class TableHandlerMeterAspect extends SimpleMicrometerAspectTool {

    @Around("execution(* com.bxm.lovelink.cm.data.TableHandler+.on*(..))")
    public Object timeRecommendService(ProceedingJoinPoint pjp) throws Throwable {
        return super.doMeter(pjp);
    }
}
