package com.bxm.lovelink.cm.mq;

import com.bxm.lovelink.cm.data.Binlog;
import com.bxm.lovelink.cm.data.TableHandlerFactory;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Allen Hu
 * @date 2025/6/19
 */
@Slf4j
public class CanalMessageListener implements SingleMessageListener {

    private final String canalTopic;
    private final String canalConsumerId;
    private final TableHandlerFactory tableHandlerFactory;

    public CanalMessageListener(CanalMqFetcher canalMqFetcher, TableHandlerFactory tableHandlerFactory) {
        this.canalTopic = canalMqFetcher.getCanalTopic();
        this.canalConsumerId = canalMqFetcher.getCanalConsumerId();
        this.tableHandlerFactory = tableHandlerFactory;
    }

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        try {
            byte[] body = message.getBody();
            String json = StringHelper.convert(body);
            tableHandlerFactory.handle(JsonHelper.convert(json, Binlog.class), json);
            return ConsumeStatus.CONSUME_SUCCESS;
        } catch (Exception e) {
            log.error("CONSUME ERROR", e);
            return ConsumeStatus.RECONSUME_LATER;
        }
    }

    @Override
    public String getTopic() {
        return canalTopic;
    }

    @Override
    public String getConsumerId() {
        return canalConsumerId;
    }

}
