package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.AiApplication;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.dto.application.AiApplacationDto;
import com.bxm.lovelink.common.dal.entity.dto.application.AiApplicationQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.application.AiApplacationVo;
import com.bxm.lovelink.common.dal.mapping.ApplicationMapping;
import com.bxm.lovelink.common.dal.service.IAiApplicationService;
import com.bxm.lovelink.common.dal.service.IAiEventService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;


/**
 * 应用管理
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/applacation")
public class AiApplicationController {

    @Autowired
    IAiApplicationService aiApplicationService;

    @Autowired
    IAiEventService eventService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiApplacationDto dto) {
        aiApplicationService.save(ApplicationMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiApplacationDto dto) {
        aiApplicationService.updateById(ApplicationMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiApplacationVo>> list(AiApplicationQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiApplicationQueryDto();
        }
        LambdaQueryWrapper<AiApplication> queryWrapper = new LambdaQueryWrapper<AiApplication>()
                .like(StringUtils.isNotEmpty(dto.getApplicationName()), AiApplication::getApplicationName, dto.getApplicationName())
                .eq(Objects.nonNull(dto.getId()), AiApplication::getId, dto.getId())
                .eq(true,AiApplication::getDeleted, Constants.NOT_DELETED)
                .eq(StringUtils.isNotEmpty(dto.getAppId()), AiApplication::getAppId, dto.getAppId());
        IPage<AiApplacationVo> voPage = ApplicationMapping.INSTANCE.toPage(aiApplicationService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        AiApplication aiApplication = aiApplicationService.getById(id);
        if(Objects.isNull(aiApplication)){
            throw new BusinessException("应用不存在");
        }
        //开始判断是否有关联的事件，如果有，则不让删除
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq(AiEvent.DELETED,Constants.NOT_DELETED);
        queryWrapper.eq(AiEvent.APPLICATION_ID,id);
        int count = eventService.getBaseMapper().selectCount(queryWrapper);
        if(count>0){
            throw new BusinessException("该模型有关联事件，无法删除！请先解除事件关联~");
        }
        aiApplication.setDeleted(Constants.DELETED);
        aiApplicationService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
