package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiChannel;
import com.bxm.lovelink.common.dal.entity.dto.channel.AiChannelDto;
import com.bxm.lovelink.common.dal.entity.dto.channel.AiChannelQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.channel.AiChannelUrlVo;
import com.bxm.lovelink.common.dal.entity.vo.channel.AiChannelVo;
import com.bxm.lovelink.common.dal.mapping.AiChannelMapping;
import com.bxm.lovelink.common.dal.service.IAiChannelService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;
import java.util.Objects;


/**
 * 渠道管理
 *
 * @author dll
 * @date 2025/5/8
 */
@Slf4j
@RestController
@RequestMapping("/channel")
public class AiChannelController {

    @Autowired
    IAiChannelService channelService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiChannelDto dto) {
        AiChannel aiChannel = AiChannelMapping.INSTANCE.dtoToDo(dto);
        channelService.save(aiChannel);
        if (aiChannel.getParentChannelId() == 0) {
            aiChannel.setChannel(aiChannel.getChannelType() + aiChannel.getId());
        } else {
            //先查询父渠道的code
            AiChannel parentChannel = channelService.getById(aiChannel.getParentChannelId());
            aiChannel.setChannel(parentChannel.getChannel() + "_" + aiChannel.getId());
        }
        channelService.updateById(aiChannel);
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiChannelDto dto) {
        AiChannel aiChannel = AiChannelMapping.INSTANCE.dtoToDo(dto);
        channelService.updateById(aiChannel);
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiChannelVo>> list(AiChannelQueryDto dto) throws Exception {
        LambdaQueryWrapper<AiChannel> queryWrapper = new LambdaQueryWrapper<AiChannel>()
                .and(StringUtils.isNotEmpty(dto.getChannelIdOrName()) ,
                        i -> i.like(AiChannel::getId,  dto.getChannelIdOrName()).or().like(AiChannel::getChannelName, dto.getChannelIdOrName()))
               /* .like(StringUtils.isNotEmpty(dto.getChannelIdOrName()), AiChannel::getId, dto.getChannelIdOrName())
                .like(StringUtils.isNotEmpty(dto.getChannelIdOrName()), AiChannel::getChannelName, dto.getChannelIdOrName())*/
                .eq(StringUtils.isNotEmpty(dto.getChannelType()), AiChannel::getChannelType, dto.getChannelType())
                .eq(Objects.nonNull(dto.getParentChannelId()), AiChannel::getParentChannelId, dto.getParentChannelId());
        //List<AiChannel>  list=  channelService.list(queryWrapper);
        //todo  后续详细数据要改成从doris里面获取，这边只是初步查询所有，看看dori是否能实现分页，不行就内存分页
        IPage<AiChannelVo> voPage = AiChannelMapping.INSTANCE.toPage(channelService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }

    /**
     * 根据渠道ID 获取渠道详情
     *
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getById")
    public ResponseEntity<AiChannelVo> getById(@RequestParam("id") Long id) throws Exception {
        AiChannelVo parentChannel = AiChannelMapping.INSTANCE.doToVo(channelService.getById(id)) ;
        if (parentChannel == null) {
            throw new Exception("根据渠道ID查不到对应的数据");
        }
        return ResponseEntity.ok(parentChannel);
    }
    /**
     * 根据渠道ID 获取渠道链接
     *
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getUrlById")
    public ResponseEntity<AiChannelUrlVo> getUrlById(@RequestParam("id") Long id) throws Exception {
        AiChannel parentChannel = getParentChannel(id);
        if (parentChannel == null) {
            throw new Exception("根据渠道ID查不到对应的数据");
        }
        //根据子渠道code，与父渠道 url 拼接
        String url = parentChannel.getUrl();
        AiChannel channel =channelService.getById(id);
        String finalUrl=getFinalUrl(url,channel.getChannel());
        AiChannelUrlVo aiChannelUrlVo=new AiChannelUrlVo();
        aiChannelUrlVo.setChannelUrl(finalUrl);
        return ResponseEntity.ok(aiChannelUrlVo);
    }

    private  AiChannel getParentChannel(Long id){
        AiChannel aiChannel = channelService.getById(id);
        if (aiChannel == null) {
           return null;
        }
        if(aiChannel.getParentChannelId()==0){
            return aiChannel;
        }
        return this.getParentChannel(aiChannel.getParentChannelId());
    }

    public static String getFinalUrl(String url, String channel) {
        try {
            MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
            params.add("channelCode", channel);
            String finalValue = UriComponentsBuilder.fromUriString(url)
                    .queryParams(params)
                    .build()
                    .toString();
            return finalValue;
        } catch (Exception e) {
            return null;
        }
    }
}
