package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventDto;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventVo;
import com.bxm.lovelink.common.dal.mapper.AiEventMapper;
import com.bxm.lovelink.common.dal.mapping.EventMapping;
import com.bxm.lovelink.common.dal.service.IAiEventService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 事件管理
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/event")
public class AiEventController {

    @Autowired
    IAiEventService aiEventService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiEventDto dto) {
        aiEventService.save(EventMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiEventDto dto) {
        aiEventService.updateById(EventMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }
    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @GetMapping("/selectById")
    public ResponseEntity<AiEventVo> selectById(@RequestParam("id") Long id) {
        AiEventVo aiEventVo =  EventMapping.INSTANCE.doToVo(aiEventService.getById(id));
        return ResponseEntity.ok(aiEventVo);
    }
    /**
     * 根据参数查找列表
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiEventVo>> list(AiEventQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiEventQueryDto();
        }
        return ResponseEntity.ok(((AiEventMapper)aiEventService.getBaseMapper()).selectByDto(new Page<>(dto.getCurrent(), dto.getSize()), dto));
    }


    /**
     * 修改状态
     * @param id
     * @param status
     * @return
     */
    @RequestMapping("/updateStatus")
    public ResponseEntity<Object> updateStatus(@RequestParam("id") Long id,
                                               @RequestParam("status") Integer status) {
        AiEvent aiEvent = aiEventService.getById(id);
        if (Objects.isNull(aiEvent)) {
            throw new BusinessException("应用不存在");
        }
        aiEvent.setStatus(status);
        aiEventService.updateById(aiEvent);
        return ResponseEntity.ok().build();
    }


    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> updateStatus(@RequestParam("id") Long id) {
        AiEvent aiEvent = aiEventService.getById(id);
        if (Objects.isNull(aiEvent)) {
            throw new BusinessException("应用不存在");
        }
        aiEvent.setDeleted(Constants.DELETED);
        aiEventService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
