package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.AiEventType;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeDto;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import com.bxm.lovelink.common.dal.mapping.EventTypeMapping;
import com.bxm.lovelink.common.dal.service.IAiEventService;
import com.bxm.lovelink.common.dal.service.IAiEventTypeService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 事件类型
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/eventType")
public class AiEventTypeController {

    @Autowired
    IAiEventTypeService iAiEventTypeService;
    @Autowired
    IAiEventService eventService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiEventTypeDto dto) {
        iAiEventTypeService.save(EventTypeMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiEventTypeDto dto) {
        iAiEventTypeService.updateById(EventTypeMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiEventTypeVo>> list(AiEventTypeQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiEventTypeQueryDto();
        }

        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(AiEventType.DELETED, Constants.NOT_DELETED);
        IPage<AiEventTypeVo> voPage = EventTypeMapping.INSTANCE.toPage(iAiEventTypeService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        AiEventType aiEventType = iAiEventTypeService.getById(id);
        if (Objects.isNull(aiEventType)) {
            throw new BusinessException("应用不存在");
        }
        //开始判断是否有关联的事件，如果有，则不让删除
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq(AiEvent.DELETED,Constants.NOT_DELETED);
        queryWrapper.eq(AiEvent.EVENT_TYPE_ID,id);
        int count = eventService.getBaseMapper().selectCount(queryWrapper);
        if(count>0){
            throw new BusinessException("该事件类型有关联二级事件，无法删除！¬请先删除二级事件~");
        }
        aiEventType.setDeleted(Constants.DELETED);
        iAiEventTypeService.updateById(aiEventType);
        return ResponseEntity.ok().build();
    }
}
