package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.*;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventDto;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.example.AiExampleDto;
import com.bxm.lovelink.common.dal.entity.dto.example.AiExampleQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventVo;
import com.bxm.lovelink.common.dal.entity.vo.example.AiExampleVo;
import com.bxm.lovelink.common.dal.mapper.AiEventMapper;
import com.bxm.lovelink.common.dal.mapping.EventMapping;
import com.bxm.lovelink.common.dal.mapping.EventTypeMapping;
import com.bxm.lovelink.common.dal.mapping.ExampleMapping;
import com.bxm.lovelink.common.dal.service.IAiEventService;
import com.bxm.lovelink.common.dal.service.IAiExampleService;
import com.bxm.lovelink.common.dal.service.IAiInterlocutorsService;
import com.bxm.lovelink.common.dal.service.IAiTemplateService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 示例管理
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/example")
public class AiExampleController {

    @Autowired
    IAiExampleService iAiExampleService;

    @Autowired
    IAiInterlocutorsService iAiInterlocutorsService;

    @Autowired
    IAiTemplateService templateService;
    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiExampleDto dto) {
        AiExample aiExample = ExampleMapping.INSTANCE.dtoToDo(dto);
        aiExample.setVersion(1);
        iAiExampleService.save(aiExample);
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiExampleDto dto) {
        AiExample aiExample = iAiExampleService.getById(dto.getId());
        //todo  保存历史表，现在没写

        AiExample newAiExample = ExampleMapping.INSTANCE.dtoToDo(dto);
        newAiExample.setVersion(aiExample.getVersion() + 1);
        iAiExampleService.updateById(newAiExample);
        return ResponseEntity.ok().build();
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @GetMapping("/selectById")
    public ResponseEntity<AiExampleVo> selectById(@RequestParam("id") Long id) {
        AiExampleVo exampleVo = ExampleMapping.INSTANCE.doToVo(iAiExampleService.getById(id));
        if (exampleVo.getInterlocutorsId() != null) {
            AiInterlocutors aiInterlocutors= iAiInterlocutorsService.getById(exampleVo.getInterlocutorsId());
            exampleVo.setAiInterlocutors(aiInterlocutors);
            if(Objects.nonNull(aiInterlocutors)){
                AiTemplate aiTemplate = templateService.getById(aiInterlocutors.getTemplateId());
                exampleVo.setTraitName(Objects.nonNull(aiTemplate)?aiTemplate.getName():null);
                exampleVo.setTraitIntro(Objects.nonNull(aiTemplate)?aiTemplate.getInstru():null);
            }
        }
        if (exampleVo.getDataTemId() != null) {
            AiTemplate aiTemplate = templateService.getById(exampleVo.getDataTemId());
            exampleVo.setDataTemIntro(Objects.nonNull(aiTemplate)?aiTemplate.getInstru():null);
        }
        if (exampleVo.getActTemId() != null) {
            AiTemplate aiTemplate = templateService.getById(exampleVo.getActTemId());
            exampleVo.setActTemIntro(Objects.nonNull(aiTemplate)?aiTemplate.getInstru():null);
        }
        if (exampleVo.getPayTemId() != null) {
            AiTemplate aiTemplate = templateService.getById(exampleVo.getPayTemId());
            exampleVo.setPayTemIntro(Objects.nonNull(aiTemplate)?aiTemplate.getInstru():null);
        }
        if (exampleVo.getSocializeTemId() != null) {
            AiTemplate aiTemplate = templateService.getById(exampleVo.getSocializeTemId());
            exampleVo.setSocializeTemIntro(Objects.nonNull(aiTemplate)?aiTemplate.getInstru():null);
        }

        return ResponseEntity.ok(exampleVo);
    }

    /**
     * 根据参数查找列表
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiExampleVo>> list(AiExampleQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiExampleQueryDto();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(AiExample.DELETED, Constants.NOT_DELETED);
        queryWrapper.eq(AiExample.EVENT_ID,dto.getEventId());
        IPage<AiExampleVo> voPage = ExampleMapping.INSTANCE.toPage(iAiExampleService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> updateStatus(@RequestParam("id") Long id) {
        AiExample example = iAiExampleService.getById(id);
        if (Objects.isNull(example)) {
            throw new BusinessException("应用不存在");
        }
        example.setDeleted(Constants.DELETED);
        iAiExampleService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
