package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.AiInterlocutors;
import com.bxm.lovelink.common.dal.entity.AiTemplate;
import com.bxm.lovelink.common.dal.entity.dto.interlocutors.AiInterlocutorsDto;
import com.bxm.lovelink.common.dal.entity.dto.interlocutors.AiInterlocutorsQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.template.AiTemplateQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.interlocutors.AiInterlocutorsVo;
import com.bxm.lovelink.common.dal.mapper.AiEventMapper;
import com.bxm.lovelink.common.dal.mapper.AiInterlocutorsMapper;
import com.bxm.lovelink.common.dal.mapping.InterlocutorsMapping;
import com.bxm.lovelink.common.dal.service.IAiInterlocutorsService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 会话人管理
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/interlocutors")
public class AiInterlocutourseController {

    @Autowired
    IAiInterlocutorsService iAiInterlocutorsService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiInterlocutorsDto dto) {
        iAiInterlocutorsService.save(InterlocutorsMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiInterlocutorsDto dto) {
        iAiInterlocutorsService.updateById(InterlocutorsMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiInterlocutorsVo>> list(AiInterlocutorsQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiInterlocutorsQueryDto();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(AiTemplate.DELETED, Constants.NOT_DELETED);
        return ResponseEntity.ok(((AiInterlocutorsMapper) iAiInterlocutorsService.getBaseMapper()).selectByDto(new Page<>(dto.getCurrent(), dto.getSize()), dto));

    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        AiInterlocutors aiInterlocutors = iAiInterlocutorsService.getById(id);
        if (Objects.isNull(aiInterlocutors)) {
            throw new BusinessException("会话人不存在");
        }
        aiInterlocutors.setDeleted(Constants.DELETED);
        iAiInterlocutorsService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
