package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.AiEventType;
import com.bxm.lovelink.common.dal.entity.AiTemplate;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeDto;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.template.AiTemplateDto;
import com.bxm.lovelink.common.dal.entity.dto.template.AiTemplateQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import com.bxm.lovelink.common.dal.entity.vo.template.AiTemplateVo;
import com.bxm.lovelink.common.dal.mapping.EventTypeMapping;
import com.bxm.lovelink.common.dal.mapping.TemplateMapping;
import com.bxm.lovelink.common.dal.service.IAiEventService;
import com.bxm.lovelink.common.dal.service.IAiEventTypeService;
import com.bxm.lovelink.common.dal.service.IAiTemplateService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 模版管理
 *
 * @author dll
 * @date 2025/4/28
 */
@Slf4j
@RestController
@RequestMapping("/template")
public class AiTemplateController {

    @Autowired
    IAiTemplateService templateService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) AiTemplateDto dto) {
        templateService.save(TemplateMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) AiTemplateDto dto) {
        templateService.updateById(TemplateMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<AiTemplateVo>> list(AiTemplateQueryDto dto) throws Exception {
        if (dto == null) {
            dto = new AiTemplateQueryDto();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(AiTemplate.DELETED, Constants.NOT_DELETED);
        if(dto.getType()!=null){
            queryWrapper.eq(AiTemplate.TYPE,dto.getType());
        }
        IPage<AiTemplateVo> voPage = TemplateMapping.INSTANCE.toPage(templateService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        AiTemplate aiTemplate = templateService.getById(id);
        if (Objects.isNull(aiTemplate)) {
            throw new BusinessException("模版不存在");
        }
        //开始判断是否有关联的事件，如果有，则不让删除

        aiTemplate.setDeleted(Constants.DELETED);
        templateService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
