package com.bxm.lovelink.cms.controller;



import com.bxm.lovelink.integration.acl.AclUserIntegration;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;


/**
 * 公共模块管理
 *
 * @author dll
 * @date 2025/5/8
 */
@Slf4j
@RestController
@RequestMapping("/common")
public class CommonController {


    @Autowired
    AclUserIntegration aclUserIntegration;

    /**
     * 根据角色查找用户
     * @param roleCode
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/findUsersByRoleCode")
    public ResponseEntity<Map<String, String>> list(@RequestParam String roleCode) throws Exception {
        Map<String, String> map=  aclUserIntegration.queryUserByRoleCode(roleCode,false);
         return ResponseEntity.ok(map);
    }


}
