package com.bxm.lovelink.cms.controller;


import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 上传图片cms
 *
 * @author dll
 * @date 2025/7/3
 */
@Slf4j
@RestController
@RequestMapping("/upload")
public class FileController {


    /**
     * 最大上传图片 3m
     */
    private final static long MAX_UPLOAD_IMG_SIZE = 30 * 1024 * 1024L;

    @Autowired
    @Qualifier("httpFileManager")
    private HttpFileManager httpFileManager;

    /**
     * 上传图片
     *
     * @param file
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/file", method = {RequestMethod.POST})
    public String uploadImg(@RequestParam("file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new Exception("上传文件不能为空！");
        }
        if (file.getSize() > MAX_UPLOAD_IMG_SIZE) {
            throw new Exception("上传文件不能大于30M！");
        }
        HttpFileRequest httpFileRequest=new HttpFileRequest();
        httpFileRequest.setMultipartFile(file);
        //httpFileRequest.setFileName( file.getOriginalFilename());
        String uploadPath = httpFileManager.upload(httpFileRequest);
        log.info("img upload success, the url : {} ", uploadPath);
        return uploadPath;
    }

}
