package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.LovelinkAppVersion;
import com.bxm.lovelink.common.dal.entity.dto.version.LovelinkAppVersionDto;
import com.bxm.lovelink.common.dal.entity.dto.version.LovelinkAppVersionQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.version.LovelinkAppVersionVo;
import com.bxm.lovelink.common.dal.mapper.AiInterlocutorsMapper;
import com.bxm.lovelink.common.dal.mapper.LovelinkAppVersionMapper;
import com.bxm.lovelink.common.dal.mapping.LovelinkAppVersionMapping;
import com.bxm.lovelink.common.dal.service.ILovelinkAppVersionService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * app版本配置
 *
 * @author dll
 * @date 2025/5/8
 */
@Slf4j
@RestController
@RequestMapping("/appVersion")
public class LovelinkAppVersionController {

    @Autowired
    ILovelinkAppVersionService appVersionService;

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) LovelinkAppVersionDto dto) {
        appVersionService.save(LovelinkAppVersionMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) LovelinkAppVersionDto dto) {
        appVersionService.updateById(LovelinkAppVersionMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }
    /**
     * 根据参数查找列表
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<LovelinkAppVersionVo>> list(LovelinkAppVersionQueryDto dto) throws Exception {
        IPage<LovelinkAppVersionVo> voPage =((LovelinkAppVersionMapper) appVersionService.getBaseMapper())
                .selectByDto(new Page<>(dto.getCurrent(), dto.getSize()), dto);
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        LovelinkAppVersion appVersion = appVersionService.getById(id);
        if(Objects.isNull(appVersion)){
            throw new BusinessException("删除的数据不存在");
        }
        appVersion.setDeleted(Constants.DELETED);
        appVersionService.removeById(id);
        return ResponseEntity.ok().build();
    }

}
