package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.LovelinkPair;
import com.bxm.lovelink.common.dal.entity.dto.pair.LoveLinkPairDto;
import com.bxm.lovelink.common.dal.entity.dto.pair.LoveLinkPairQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.pair.LoveLinkPairVo;
import com.bxm.lovelink.common.dal.mapping.LovelinkPairMapping;
import com.bxm.lovelink.common.dal.service.ILovelinkPairService;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 系统配置
 *
 * @author dll
 * @date 2025/5/8
 */
@Slf4j
@RestController
@RequestMapping("/pair")
public class LovelinkPairController {

    @Autowired
    ILovelinkPairService lovelinkPairService;

    @Autowired
    private RedisPairImpl pair;

    /**
     * 新增或者修改
     * @param dto
     * @return
     */
    @PostMapping("/saveOrUpdate")
    public ResponseEntity<Object> add(@RequestBody @Validated LoveLinkPairDto dto) {
        LovelinkPair lovelinkPair = LovelinkPairMapping.INSTANCE.dtoToDo(dto);
        if (!lovelinkPairService.saveOrUpdate(lovelinkPair)) {
            throw new RuntimeException("保存失败");
        }
        pair.set(lovelinkPair.getKey(),lovelinkPair.getValue());
        return ResponseEntity.ok().build();
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") String id) {
        if (!lovelinkPairService.removeById(id)) {
            throw new RuntimeException("删除失败,请检查删除的配置是否存在");
        }
        pair.delete(id);
        return ResponseEntity.ok().build();
    }

    /**
     * 根据参数查找列表
     *
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<LoveLinkPairVo>> list(LoveLinkPairQueryDto dto) throws Exception {
        LambdaQueryWrapper<LovelinkPair> lambdaQueryWrapper=new LambdaQueryWrapper<LovelinkPair>();
        lambdaQueryWrapper.eq(StringUtils.isNotBlank(dto.getKey()),LovelinkPair::getKey,dto.getKey());
        IPage<LoveLinkPairVo> voPage = LovelinkPairMapping.INSTANCE.toPage(lovelinkPairService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), lambdaQueryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 根据key获取配置信息
     * @param key
     * @return
     */
    @GetMapping("/getByKey")
    public ResponseEntity<String> getByKey(@RequestParam("key") String key) {
        LambdaQueryWrapper<LovelinkPair> lambdaQueryWrapper=new LambdaQueryWrapper<LovelinkPair>();
        lambdaQueryWrapper.eq(LovelinkPair::getKey,key);
        LovelinkPair lovelinkPair= lovelinkPairService.getBaseMapper().selectOne(lambdaQueryWrapper);
        if(Objects.isNull(lovelinkPair)){
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.ok(lovelinkPair.getValue());
    }

}
