package com.bxm.lovelink.cms.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.dto.pushtask.PushTaskDto;
import com.bxm.lovelink.common.dal.entity.dto.pushtask.PushTaskQueryDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.pushtask.PushTaskVo;
import com.bxm.lovelink.common.dal.mapping.PushTaskMapping;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.push.factory.PushScene;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;


/**
 * 推送任务管理
 *
 * @author dll
 * @date 2025/6/13
 */
@Slf4j
@RestController
@RequestMapping("/pushTask")
public class PushTaskController {

    @Autowired
    private IPushTaskService pushTaskService;


    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) PushTaskDto dto) {
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq(PushTask.TASK_SCENE,dto.getTaskScene());
        //如果是约见邀请即将过期 与 用户流失召回 ,则要加下面的查询条件
        if(StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.USER_RECALL_LOSS.name())
        || StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.EXPIRE_MEET_REQUEST.name())
        || StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.ACTIVITY_START.name())){
            if(StringUtils.isBlank(dto.getTaskSceneCustomConfig())){
                throw new BusinessException("约见邀请即将过期 与 用户流失召回 场景的时候，任务场景的特定配置不能为空");
            }
            queryWrapper.eq(PushTask.TASK_SCENE_CUSTOM_CONFIG,dto.getTaskSceneCustomConfig());
        }
        int count =pushTaskService.count(queryWrapper);
        if(count>0){
            throw new BusinessException("数据重复");
        }
        pushTaskService.save(PushTaskMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) PushTaskDto dto) {
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq(PushTask.TASK_SCENE,dto.getTaskScene());
        //如果是约见邀请即将过期 与 用户流失召回 ,则要加下面的查询条件
        if(StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.USER_RECALL_LOSS.name())
                || StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.EXPIRE_MEET_REQUEST.name())
        || StringUtils.equalsIgnoreCase(dto.getTaskScene(), PushScene.ACTIVITY_START.name())){
            if(StringUtils.isBlank(dto.getTaskSceneCustomConfig())){
                throw new BusinessException("约见邀请即将过期 与 用户流失召回 场景的时候，任务场景的特定配置不能为空");
            }
            queryWrapper.eq(PushTask.TASK_SCENE_CUSTOM_CONFIG,dto.getTaskSceneCustomConfig());
        }
        queryWrapper.notIn(PushTask.ID,dto.getId());
        int count =pushTaskService.count(queryWrapper);
        if(count>0){
            throw new BusinessException("修改的数据已经存在");
        }
        pushTaskService.updateById(PushTaskMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }
    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @GetMapping("/selectById")
    public ResponseEntity<PushTaskVo> selectById(@RequestParam("id") Long id) {
        PushTaskVo pushTaskVo =  PushTaskMapping.INSTANCE.doToVo(pushTaskService.getById(id));
        return ResponseEntity.ok(pushTaskVo);
    }
    /**
     * 根据参数查找列表
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<PushTaskVo>> list(PushTaskQueryDto dto) throws Exception {
        LambdaQueryWrapper<PushTask> lambdaQueryWrapper=new LambdaQueryWrapper<PushTask>()
                .like(StringUtils.isNotBlank(dto.getTaskName()), PushTask::getTaskName, dto.getTaskName());
        IPage<PushTaskVo> voPage = PushTaskMapping.INSTANCE.toPage(pushTaskService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), lambdaQueryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 修改状态  0 关闭  1 启用
     * @param id
     * @param status
     * @return
     */
    @RequestMapping("/updateStatus")
    public ResponseEntity<Object> updateStatus(@RequestParam("id") Long id,
                                               @RequestParam("status") Integer status) {
        PushTask pushTask = pushTaskService.getById(id);
        if (Objects.isNull(pushTask)) {
            throw new BusinessException("数据不存在");
        }
        pushTask.setStatus(status);
        pushTaskService.updateById(pushTask);
        return ResponseEntity.ok().build();
    }

}
