package com.bxm.lovelink.cms.controller.activity;


import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityCenterVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.evaluation.ActivityEvaluationVo;
import com.bxm.lovelink.common.dal.mapper.ActivityEvaluationMapper;
import com.bxm.lovelink.common.dal.service.IActivityEvaluationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 活动评价详情
 *
 * @author dll
 * @date 2025/6/25
 */
@Slf4j
@RestController
@RequestMapping("/activity/evaluation")
public class ActivityEvaluationController {

    private final IActivityEvaluationService activityEvaluationService;

    public ActivityEvaluationController(IActivityEvaluationService activityEvaluationService) {
        this.activityEvaluationService = activityEvaluationService;
    }

    /**
     * 列表查询
     *
     * @param activityId
     * @return
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<List<ActivityEvaluationVo>> list(@RequestParam("activityId") Long activityId) {
        return ResponseEntity.ok(((ActivityEvaluationMapper) activityEvaluationService.getBaseMapper()).selectByActivityId(activityId));
    }


}
