package com.bxm.lovelink.cms.controller.activity;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityOrganizer;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.entity.AiApplication;
import com.bxm.lovelink.common.dal.entity.dto.activity.organizer.ActivityOrganizerDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.organizer.ActivityOrganizerQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.type.ActivityTypeDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.activity.organizer.ActivityOrganizerVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.type.ActivityTypeVo;
import com.bxm.lovelink.common.dal.entity.vo.application.AiApplacationVo;
import com.bxm.lovelink.common.dal.mapping.ApplicationMapping;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityOrganizerMapping;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityTypeMapping;
import com.bxm.lovelink.common.dal.service.IActivityOrganizerService;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.impl.huawei.impl.StringUtil;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;


/**
 * 活动负责人管理
 *
 * @author dll
 * @date 2025/6/24
 */
@Slf4j
@RestController
@RequestMapping("/activity/organizer")
public class ActivityOrganizerController {

    private final IActivityOrganizerService activityOrganizerService;
    private final IActivityService activityService;

    public ActivityOrganizerController(IActivityOrganizerService activityOrganizerService, IActivityService activityService) {
        this.activityOrganizerService = activityOrganizerService;
        this.activityService = activityService;
    }


    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) ActivityOrganizerDto dto) {
        activityOrganizerService.save(ActivityOrganizerMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) ActivityOrganizerDto dto) {
        activityOrganizerService.updateById(ActivityOrganizerMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }


    /**
     * 列表查询
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<ActivityOrganizerVo>> list(ActivityOrganizerQueryDto dto) throws Exception {
        LambdaQueryWrapper<ActivityOrganizer> queryWrapper = new LambdaQueryWrapper<ActivityOrganizer>()
                .like(StringUtils.isNotEmpty(dto.getName()), ActivityOrganizer::getName, dto.getName())
                .eq(StringUtils.isNotEmpty(dto.getCityCode()), ActivityOrganizer::getCityCode, dto.getCityCode());
        IPage<ActivityOrganizerVo> voPage = ActivityOrganizerMapping.INSTANCE.toPage(activityOrganizerService.getBaseMapper()
                .selectPage(new Page<>(dto.getCurrent(), dto.getSize()), queryWrapper));
        return ResponseEntity.ok(voPage);
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        ActivityOrganizer activityOrganizer = activityOrganizerService.getById(id);
        if (Objects.isNull(activityOrganizer)) {
            throw new BusinessException("删除的数据不存在");
        }
        if (StringUtils.isBlank(activityOrganizer.getSupportActivityTypes())) {
            activityOrganizerService.removeById(id);
        }
        List<String> activityTypeList = JSONObject.parseArray(activityOrganizer.getSupportActivityTypes(), String.class);
        //开始判断是否有关联的活动，如果有，则不让删除
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(Activity.ACTIVITY_TYPE_ID, activityTypeList);
        int count = activityService.getBaseMapper().selectCount(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该活动负责人有关联活动，无法删除");
        }
        activityOrganizerService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
