package com.bxm.lovelink.cms.controller.activity;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.dto.activity.type.ActivityTypeDto;
import com.bxm.lovelink.common.dal.entity.validate.InsertGroup;
import com.bxm.lovelink.common.dal.entity.validate.UpdateGroup;
import com.bxm.lovelink.common.dal.entity.vo.activity.type.ActivityTypeVo;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityTypeMapping;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IActivityTypeService;
import com.bxm.lovelink.common.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;


/**
 * 活动类型管理
 *
 * @author dll
 * @date 2025/6/24
 */
@Slf4j
@RestController
@RequestMapping("/activity/type")
public class ActivityTypeController {

    private final IActivityTypeService activityTypeService;
    private final IActivityService activityService;

    public ActivityTypeController(IActivityTypeService activityTypeService, IActivityService activityService) {
        this.activityTypeService = activityTypeService;
        this.activityService = activityService;
    }


    /**
     * 新增
     *
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResponseEntity<Object> add(@RequestBody @Validated(InsertGroup.class) ActivityTypeDto dto) {
        activityTypeService.save(ActivityTypeMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }

    /**
     * 修改
     *
     * @param dto
     * @return
     */
    @PostMapping("/update")
    public ResponseEntity<Object> update(@RequestBody @Validated(UpdateGroup.class) ActivityTypeDto dto) {
        activityTypeService.updateById(ActivityTypeMapping.INSTANCE.dtoToDo(dto));
        return ResponseEntity.ok().build();
    }


    /**
     * 列表查询
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<List<ActivityTypeVo>> list() throws Exception {
        List<ActivityTypeVo> list = ActivityTypeMapping.INSTANCE.toList(activityTypeService.list());
        return ResponseEntity.ok(list);
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public ResponseEntity<Object> delete(@RequestParam("id") Long id) {
        ActivityType activityType = activityTypeService.getById(id);
        if (Objects.isNull(activityType)) {
            throw new BusinessException("删除的数据不存在");
        }
        //开始判断是否有关联的事件，如果有，则不让删除
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(Activity.ACTIVITY_TYPE_ID, id);
        int count = activityService.getBaseMapper().selectCount(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该类型有关联活动，无法删除");
        }
        activityType.setDeleted(Constants.DELETED);
        activityTypeService.removeById(id);
        return ResponseEntity.ok().build();
    }
}
