package com.bxm.lovelink.cms.controller.activity;


import cn.hutool.core.lang.hash.Hash;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection.ActivityUserMutualSelectionQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserMutualSelectionVo;
import com.bxm.lovelink.common.dal.mapper.ActivityUserMutualSelectionMapper;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import java.util.stream.Stream;


/**
 * 活动中心-互选表
 *
 * @author dll
 * @date 2025/6/24
 */
@Slf4j
@RestController
@RequestMapping("/activity/userMutualSelection")
public class ActivityUserMutualSelectionController {
    private final IActivityUserMutualSelectionService iActivityUserMutualSelectionService;

    private final IUserBasicInfoService userBasicInfoService;

    public ActivityUserMutualSelectionController(IActivityUserMutualSelectionService iActivityUserMutualSelectionService, IUserBasicInfoService userBasicInfoService) {
        this.iActivityUserMutualSelectionService = iActivityUserMutualSelectionService;
        this.userBasicInfoService = userBasicInfoService;
    }

    /**
     * 列表查询
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/list")
    public ResponseEntity<IPage<ActivityUserMutualSelectionVo>> list(ActivityUserMutualSelectionQueryDto dto) throws Exception {
        IPage<ActivityUserMutualSelectionVo> page = ((ActivityUserMutualSelectionMapper) iActivityUserMutualSelectionService.getBaseMapper()).selectByDto(new Page<>(dto.getCurrent(), dto.getSize()), dto);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return ResponseEntity.ok(page);
        }
        List<Long> userIds = page.getRecords().stream()
                .flatMap(vo -> Stream.of(vo.getUserIdA(), vo.getUserIdB()))
                .collect(Collectors.toList());

        List<UserBasicInfo> list = userBasicInfoService.listByIds(userIds);
        Map<Long, String> map =new HashMap<>();
        for(UserBasicInfo userBasicInfo:list){
            map.put(userBasicInfo.getUserId(),userBasicInfo.getNickname());
        }

        for(ActivityUserMutualSelectionVo activityUserMutualSelectionVo:page.getRecords()){
            activityUserMutualSelectionVo.setNicknameA(map.get(activityUserMutualSelectionVo.getUserIdA()));
            activityUserMutualSelectionVo.setNicknameB(map.get(activityUserMutualSelectionVo.getUserIdB()));
        }
        return ResponseEntity.ok(page);
    }


}
