package com.bxm.lovelink.cms.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.function.Function;


@Configuration
public class InterceptorConfigurer extends WebMvcConfigurerAdapter {


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
        // addPathPatterns 用于添加拦截规则
        registry.addInterceptor(aclAuthInterceptor())
                .addPathPatterns("/*/**")
                .excludePathPatterns("/upload/*")
                .excludePathPatterns("/chat/**");
        super.addInterceptors(registry);
    }

    @Bean
    public AclAuthInterceptor aclAuthInterceptor() {
        return new AclAuthInterceptor(46, new Function<String, String>() {
            @Override
            public String apply(String s) {
                // 如果是活动相关的，统一成一个活动权限。
                if (s.startsWith("/activity/")) {
                    return "/activity/**";
                } else {
                    return "/lovelink/**";
                }
            }
        });
    }
}
