package com.bxm.lovelink.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author tangxiao
 * @date 2025/5/16
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "lovelink.global")
public class LoveLinkGlobalConfig {
    /**
     * 支付回调地址
     */
    private String payNotifyUrl;
    /**
     * 退款回调地址
     */
    private String refundNotifyUrl;

    /**
     * Openlog 请求地址
     */
    private String openLogRequestUrl = "https://openlog.bxmdev.com";
}
