package com.bxm.lovelink.common.autoconfigure;

import com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.none.NoneSensitiveImageIntegration;
import com.bxm.lovelink.common.integration.sensitive.none.NoneSensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.nut.NutWallSensitiveProperties;
import com.bxm.lovelink.common.integration.sensitive.wangyi.WangYiSensitiveProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Allen Hu
 * @date 2025/5/20
 */
@Configuration
@EnableConfigurationProperties({
        NutWallSensitiveProperties.class,
        WangYiSensitiveProperties.class
})
public class SensitiveAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(SensitiveTextIntegration.class)
    public SensitiveTextIntegration noneSensitiveTextIntegration() {
        return new NoneSensitiveTextIntegration();
    }

    @Bean
    @ConditionalOnMissingBean(SensitiveImageIntegration.class)
    public SensitiveImageIntegration noneSensitiveImageIntegration() {
        return new NoneSensitiveImageIntegration();
    }

}
