package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

import java.time.Duration;

/**
 * userId > userNumber 映射缓存
 *
 * @author Allen Hu
 * @date 2025/7/10
 */
@Service
public class UserId2NumberMappingCache extends AbstractTableCache<String> {

    private final IUserService userService;

    public UserId2NumberMappingCache(Fetcher fetcher, Updater updater, RedissonClient redissonClient, LoadingCacheFetcher loadingCacheFetcher, IUserService userService) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userService = userService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.stringUserId2UserNumberMapping(userId);
    }

    @Override
    public String getFromDatabase(Long userId) {
        User user = userService.getById(userId);
        if (user == null) {
            return null;
        }
        return user.getUserNumber();
    }

    @Override
    public Class<String> getCacheClass() {
        return String.class;
    }

    @Override
    protected boolean isLockingForUpdate() {
        return false;
    }

    @Override
    protected int getExpireTime() {
        return (int) Duration.ofDays(30).getSeconds();
    }

}
