package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2025/7/2
 */
@Component
public class UserLoveConditionTableCache extends AbstractTableCache<UserLoveCondition> {

    private final IUserLoveConditionService userLoveConditionService;

    public UserLoveConditionTableCache(RedissonClient redissonClient, Fetcher fetcher, Updater updater, IUserLoveConditionService userLoveConditionService, LoadingCacheFetcher loadingCacheFetcher) {
        super(fetcher, updater, redissonClient,loadingCacheFetcher);
        this.userLoveConditionService = userLoveConditionService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.userLoveConditionCache(userId);
    }

    @Override
    public UserLoveCondition getFromDatabase(Long userId) {
        return userLoveConditionService.getOneByUserId(userId);
    }

    @Override
    public Class<UserLoveCondition> getCacheClass() {
        return UserLoveCondition.class;
    }
}
