package com.bxm.lovelink.common.cache;

import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.xcache.fetchers.LoadingCacheFetcher;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2025/7/2
 */
@Component
public class UserOtherTableCache extends AbstractTableCache<UserOtherInfo> {

    private final IUserOtherInfoService userOtherInfoService;

    public UserOtherTableCache(RedissonClient redissonClient, Fetcher fetcher, Updater updater, IUserOtherInfoService userOtherInfoService, LoadingCacheFetcher loadingCacheFetcher) {
        super(fetcher, updater, redissonClient, loadingCacheFetcher);
        this.userOtherInfoService = userOtherInfoService;
    }

    @Override
    public KeyGenerator getKeyGenerator(Long userId) {
        return RedisKeys.userOtherCache(userId);
    }

    @Override
    public UserOtherInfo getFromDatabase(Long userId) {
        return userOtherInfoService.getOneByUserId(userId);
    }

    @Override
    public Class<UserOtherInfo> getCacheClass() {
        return UserOtherInfo.class;
    }
}
