package com.bxm.lovelink.common.chat;

import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.warcar.utils.JsonHelper;
import lombok.Builder;
import lombok.Data;
import org.apache.catalina.connector.ClientAbortException;
import org.springframework.lang.Nullable;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

/**
 * @author Allen Hu
 * @date 2025/6/26
 */
@Data
@Builder
public class ChatRequest {

    private User user;

    private ChatSession chatSession;

    private List<ChatSessionMessage> chatSessionMessages;

    /**
     * 调用智能体（对话流等）时的参数
     */
    private Map<String, Object> parameter;

    /**
     * 写入流接口
     */
    @Nullable
    private ByteWriter<byte[]> writeConsumer;
    /**
     * 刷新缓冲接口
     */
    @Nullable
    private SimpleHandler flusher;
    /**
     * 完成接口
     */
    @Nullable
    private CompleteConsumer complete;
    /**
     * 用户取消接口
     */
    @Nullable
    private BiConsumer<ClientAbortException, String> clientAbortExceptionStringBiConsumer;

    public void doWriteAndFlush(byte[] bytes) throws IOException {
        doWrite(bytes);
        doFlush();
    }

    public void doWriteAndFlush(String content) throws IOException {
        if (null != content) {
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            doWriteAndFlush(bytes);
        }
    }

    public void doWriteAndFlush(SseEventData sseEventData) throws IOException {
        doWriteAndFlush(JsonHelper.convert(sseEventData));
    }

    public void doWriteAndFlushQuietly(SseEventData sseEventData) {
        try {
            doWriteAndFlush(sseEventData);
        } catch (IOException ignored) {
        }
    }

    public void doWrite(byte[] bytes) throws IOException {
        if (writeConsumer != null) {
            writeConsumer.write(bytes);
        }
    }

    public void doFlush() {
        if (flusher != null) {
            try {
                flusher.execute();
            } catch (IOException ignored) {
            }
        }
    }

    public void doComplete(List<ChatSessionMessage> messages) {
        if (complete != null) {
            complete.accept(messages);
        }
    }
}
