package com.bxm.lovelink.common.chat;

public interface ChatService {

    /**
     * 发起一个流式聊天
     * 流式输出的数据接收实现接口定义在请求里。
     * 流式响应的数据模型是JSON序列化 {@link SseEventData} 对象。
     *
     * @param request 聊天请求
     */
    void stream(ChatRequest request);

    /**
     * 取消一个流式聊天
     * @param conversionId 会话ID，从{@link SseEventData} 对象获取。
     */
    void cancel(String conversionId);
}
