package com.bxm.lovelink.common.chat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author Allen Hu
 * @date 2025/6/26
 */
@Data
@Builder
public class SseEventData {

    /**
     * 建立连接的握手消息，主要用来发送一些前置数据
     */
    public static final String STATUS_CREATED = "0";
    /**
     * 已经成功创建，但还没开始输出内容
     */
    public static final String STATUS_START = "1";
    /**
     * 消息输出中
     */
    public static final String STATUS_MESSAGE = "2";
    /**
     * 发生了异常
     */
    public static final String STATUS_FAILED = "3";

    /**
     * 注意这是本项目的conversionId，不是Coze的conversationId
     */
    private String conversionId;
    /**
     * 深度思考的内容
     */
    private String reasoningContent;
    /**
     * 普通的内容
     */
    private String content;
    /**
     * 状态
     */
    private String status;
    /**
     * 时间
     */
    private String time;
    /**
     * 异常信息，不展示给用户的
     */
    private String error;

    public static String getNowTimeString() {
        return LocalDateTimeHelper.formatToString(LocalDateTime.now(), LocalDateTimeHelper.PATTERN_STR19);
    }
}
